	function [symbits, symadd, sympass] = symmetryadder(w, k, signed)
	%[symbits, symadd, sympass] = symmetryadder(w, k, signed)
	%
	%Create a description of a symmetry adder with a specified block size
	%
	%Arguments:
	%  w - the length of the adder
	%  k - the symmetry block size
	%  signed - inhibits reduction of lone half adder at msb
	%
	%Returns:
	%  symbits - the output bit matrix
	%  symadd - list of adders and expected input
	%  sympass - list of leftover input bits which are not added
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	adder = @(m) (m == 1) * vertcat(horzcat(zeros(1, m), 2), zeros(m, m+1)) + ...
		(m > 1) * vertcat(zeros(1, m+1), horzcat(vertcat(zeros(m-1, 1), 1), fliplr(eye(m))));
	adder2 = @(m) vertcat(zeros(1, m+1), horzcat(vertcat(zeros(m-1, 1), 1), fliplr(eye(m))));
	
	A = zeros(k+1, w+1);
	symadd = [];
	sympass = [];
	
	i = 0;
	while w-i > k
		A(:, w-k-i+1:w-i+1) = A(:, w-k-i+1:w-i+1) + adder(k);
		symadd = [symadd; i+k-1 i];
		i = i + k;
	end
	if signed == 0
		A(1:w-i+1, 1:w-i+1) = A(1:w-i+1, 1:w-i+1) + adder(w-i);
	else
		A(1:w-i+1, 1:w-i+1) = A(1:w-i+1, 1:w-i+1) + adder2(w-i);
	end
	if w-i > 1 | signed == 1
		symadd = [symadd; w-1 i];
	else
		sympass = w-1;
	end
	
	symbits = A;
	
